/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.init.group;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public abstract class ColoredGroup<T, U extends ColoredGroup<T, U>> {
    private final Map<DyeColor, T> entries = new HashMap<DyeColor, T>();

    protected ColoredGroup() {
    }

    public U add(DyeColor color, ColoredConstructor<T> constructor) {
        this.entries.put(color, constructor.create(color));
        return (U)this;
    }

    public U add16Colors(ColoredConstructor<T> constructor) {
        for (DyeColor color : DyeColor.values()) {
            this.entries.put(color, constructor.create(color));
        }
        return (U)this;
    }

    public T get(DyeColor color) {
        return this.entries.get(color);
    }

    public List<T> getList() {
        return List.of(this.get(DyeColor.BLACK), this.get(DyeColor.GRAY), this.get(DyeColor.LIGHT_GRAY), this.get(DyeColor.WHITE), this.get(DyeColor.BROWN), this.get(DyeColor.BLUE), this.get(DyeColor.CYAN), this.get(DyeColor.LIGHT_BLUE), this.get(DyeColor.LIME), this.get(DyeColor.GREEN), this.get(DyeColor.YELLOW), this.get(DyeColor.ORANGE), this.get(DyeColor.RED), this.get(DyeColor.PINK), this.get(DyeColor.MAGENTA), this.get(DyeColor.PURPLE));
    }

    protected abstract void registerSingle(ResourceLocation var1, T var2);

    public U register(String baseName) {
        for (Map.Entry<DyeColor, T> entry : this.entries.entrySet()) {
            this.registerSingle(ConvenientDecor.id(entry.getKey().m_41065_() + "_" + baseName), entry.getValue());
        }
        return (U)this;
    }

    public static ColoredItemGroup ofItems() {
        return new ColoredItemGroup();
    }

    public static ColoredBlockGroup ofBlocks(boolean withBlockItem) {
        return new ColoredBlockGroup(withBlockItem);
    }

    @FunctionalInterface
    public static interface ColoredConstructor<T> {
        public T create(DyeColor var1);
    }

    public static class ColoredItemGroup
    extends ColoredGroup<Item, ColoredItemGroup> {
        @Override
        protected void registerSingle(ResourceLocation id, Item entry) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)id, (Object)entry);
        }

        public List<ItemStack> getItemStackList() {
            return this.getList().stream().map(item -> item.m_7968_()).toList();
        }
    }

    public static class ColoredBlockGroup
    extends ColoredGroup<Block, ColoredBlockGroup> {
        private final boolean withBlockItem;

        protected ColoredBlockGroup(boolean withBlockItem) {
            this.withBlockItem = withBlockItem;
        }

        @Override
        protected void registerSingle(ResourceLocation id, Block entry) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256975_, (ResourceLocation)id, (Object)entry);
            if (this.withBlockItem) {
                Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)id, (Object)new BlockItem(entry, (Item.Properties)new FabricItemSettings()));
            }
        }

        public List<ItemStack> getItemStackList() {
            return this.getList().stream().map(block -> block.m_5456_().m_7968_()).toList();
        }
    }
}

